package com.ejie.ab04b.dao;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.annotation.Resource;
import javax.sql.DataSource;

import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.ab04b.model.VmotivosSubsanacionExpOs2;
import com.ejie.x38.dao.RowNumResultSetExtractor;
import com.ejie.x38.dto.JQGridManager;
import com.ejie.x38.dto.JQGridRequestDto;
import com.ejie.x38.dto.TableRowDto;

/**
 * VmotivosSubsanacionExpOs2DaoImpl generated by UDA, 08-jun-2017 15:14:23.
 * 
 * @author UDA
 */

@Repository
@Transactional
public class VmotivosSubsanacionExpOs2DaoImpl implements
		VmotivosSubsanacionExpOs2Dao {
	private JdbcTemplate jdbcTemplate;

	/*
	 * ROW_MAPPERS
	 */
	private RowMapper<VmotivosSubsanacionExpOs2> rwMap = new RowMapper<VmotivosSubsanacionExpOs2>() {
		public VmotivosSubsanacionExpOs2 mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new VmotivosSubsanacionExpOs2(resultSet.getString("TEROS"),
					resultSet.getString("ANOOS"), resultSet.getInt("NUMOS"),
					resultSet.getLong("IDTRAMITE"),
					resultSet.getLong("TIPOTRAMITE"),
					resultSet.getLong("IDTAREA"),
					resultSet.getLong("TIPOTAREA"),
					resultSet.getString("CODMOTIVO"),
					resultSet.getString("DESCRIPCIONES"),
					resultSet.getString("DESCRIPCIONEUS"),
					resultSet.getString("DESCOTROSES"),
					resultSet.getString("DESCOTROSEU"));
		}
	};

	private RowMapper<VmotivosSubsanacionExpOs2> rwMapPK = new RowMapper<VmotivosSubsanacionExpOs2>() {
		public VmotivosSubsanacionExpOs2 mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new VmotivosSubsanacionExpOs2(resultSet.getString("TEROS"),
					resultSet.getString("ANOOS"), resultSet.getInt("NUMOS"),
					resultSet.getLong("IDTRAMITE"),
					resultSet.getLong("TIPOTRAMITE"),
					resultSet.getLong("IDTAREA"),
					resultSet.getLong("TIPOTAREA"),
					resultSet.getString("CODMOTIVO"),
					resultSet.getString("DESCRIPCIONES"),
					resultSet.getString("DESCRIPCIONEUS"),
					resultSet.getString("DESCOTROSES"),
					resultSet.getString("DESCOTROSEU"));
		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 *  dataSource            DataSource
	 *
	 * @param dataSource the new data source
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/*
	 * OPERACIONES CRUD
	 */

	/**
	 * Inserts a single row in the VmotivosSubsanacionExpOs2 table.
	 * 
	 *  vmotivossubsanacionexpos2
	 *            VmotivosSubsanacionExpOs2
	 *  VmotivosSubsanacionExpOs2
	 *
	 * @param vmotivossubsanacionexpos2 the vmotivossubsanacionexpos 2
	 * @return the vmotivos subsanacion exp os 2
	 */
	public VmotivosSubsanacionExpOs2 add(
			VmotivosSubsanacionExpOs2 vmotivossubsanacionexpos2) {
		String query = "INSERT INTO VMOTIVOS_SUBSANACION_EXP_OS2 (TEROS, ANOOS, NUMOS, ID_TRAMITE, TIPO_TRAMITE, ID_TAREA, TIPO_TAREA, CODMOTIVO, DESCRIPCION_ES, DESCRIPCION_EUS, DESC_OTROS_ES, DESC_OTROS_EU) VALUES (?,?,?,?,?,?,?,?,?,?,?,?)";
		this.jdbcTemplate.update(query, vmotivossubsanacionexpos2.getTeros(),
				vmotivossubsanacionexpos2.getAnoos(),
				vmotivossubsanacionexpos2.getNumos(),
				vmotivossubsanacionexpos2.getIdTramite(),
				vmotivossubsanacionexpos2.getTipoTramite(),
				vmotivossubsanacionexpos2.getIdTarea(),
				vmotivossubsanacionexpos2.getTipoTarea(),
				vmotivossubsanacionexpos2.getCodmotivo(),
				vmotivossubsanacionexpos2.getDescripcionEs(),
				vmotivossubsanacionexpos2.getDescripcionEus(),
				vmotivossubsanacionexpos2.getDescOtrosEs(),
				vmotivossubsanacionexpos2.getDescOtrosEu());
		return vmotivossubsanacionexpos2;
	}

	/**
	 * Updates a single row in the VmotivosSubsanacionExpOs2 table.
	 * 
	 *  vmotivossubsanacionexpos2
	 *            VmotivosSubsanacionExpOs2
	 *  VmotivosSubsanacionExpOs2
	 *
	 * @param vmotivossubsanacionexpos2 the vmotivossubsanacionexpos 2
	 * @return the vmotivos subsanacion exp os 2
	 */
	public VmotivosSubsanacionExpOs2 update(
			VmotivosSubsanacionExpOs2 vmotivossubsanacionexpos2) {
		String query = "UPDATE VMOTIVOS_SUBSANACION_EXP_OS2 SET  WHERE TEROS=? AND ANOOS=? AND NUMOS=? AND ID_TRAMITE=? AND TIPO_TRAMITE=? AND ID_TAREA=? AND TIPO_TAREA=? AND CODMOTIVO=? AND DESCRIPCION_ES=? AND DESCRIPCION_EUS=? AND DESC_OTROS_ES=? AND DESC_OTROS_EU=?";
		this.jdbcTemplate.update(query, vmotivossubsanacionexpos2.getTeros(),
				vmotivossubsanacionexpos2.getAnoos(),
				vmotivossubsanacionexpos2.getNumos(),
				vmotivossubsanacionexpos2.getIdTramite(),
				vmotivossubsanacionexpos2.getTipoTramite(),
				vmotivossubsanacionexpos2.getIdTarea(),
				vmotivossubsanacionexpos2.getTipoTarea(),
				vmotivossubsanacionexpos2.getCodmotivo(),
				vmotivossubsanacionexpos2.getDescripcionEs(),
				vmotivossubsanacionexpos2.getDescripcionEus(),
				vmotivossubsanacionexpos2.getDescOtrosEs(),
				vmotivossubsanacionexpos2.getDescOtrosEu());
		return vmotivossubsanacionexpos2;
	}

	/**
	 * Finds a single row in the VmotivosSubsanacionExpOs2 table.
	 * 
	 *  vmotivossubsanacionexpos2
	 *            VmotivosSubsanacionExpOs2
	 *  VmotivosSubsanacionExpOs2
	 *
	 * @param vmotivossubsanacionexpos2 the vmotivossubsanacionexpos 2
	 * @return the vmotivos subsanacion exp os 2
	 */
	@Transactional(readOnly = true)
	public VmotivosSubsanacionExpOs2 find(
			VmotivosSubsanacionExpOs2 vmotivossubsanacionexpos2) {
		String query = "SELECT t1.TEROS TEROS, t1.ANOOS ANOOS, t1.NUMOS NUMOS, t1.ID_TRAMITE IDTRAMITE, t1.TIPO_TRAMITE TIPOTRAMITE, t1.ID_TAREA IDTAREA, t1.TIPO_TAREA TIPOTAREA, t1.CODMOTIVO CODMOTIVO, t1.DESCRIPCION_ES DESCRIPCIONES, t1.DESCRIPCION_EUS DESCRIPCIONEUS, t1.DESC_OTROS_ES DESCOTROSES, t1.DESC_OTROS_EU DESCOTROSEU FROM VMOTIVOS_SUBSANACION_EXP_OS2 t1  WHERE t1.TEROS = ?   AND t1.ANOOS = ?   AND t1.NUMOS = ?   AND t1.ID_TRAMITE = ?   AND t1.TIPO_TRAMITE = ?   AND t1.ID_TAREA = ?   AND t1.TIPO_TAREA = ?   AND t1.CODMOTIVO = ?   AND t1.DESCRIPCION_ES = ?   AND t1.DESCRIPCION_EUS = ?   AND t1.DESC_OTROS_ES = ?   AND t1.DESC_OTROS_EU = ?  ";

		List<VmotivosSubsanacionExpOs2> vmotivossubsanacionexpos2List = this.jdbcTemplate
				.query(query, this.rwMap, vmotivossubsanacionexpos2.getTeros(),
						vmotivossubsanacionexpos2.getAnoos(),
						vmotivossubsanacionexpos2.getNumos(),
						vmotivossubsanacionexpos2.getIdTramite(),
						vmotivossubsanacionexpos2.getTipoTramite(),
						vmotivossubsanacionexpos2.getIdTarea(),
						vmotivossubsanacionexpos2.getTipoTarea(),
						vmotivossubsanacionexpos2.getCodmotivo(),
						vmotivossubsanacionexpos2.getDescripcionEs(),
						vmotivossubsanacionexpos2.getDescripcionEus(),
						vmotivossubsanacionexpos2.getDescOtrosEs(),
						vmotivossubsanacionexpos2.getDescOtrosEu());
		return (VmotivosSubsanacionExpOs2) DataAccessUtils
				.uniqueResult(vmotivossubsanacionexpos2List);
	}

	/**
	 * Removes a single row in the VmotivosSubsanacionExpOs2 table.
	 * 
	 *  vmotivossubsanacionexpos2            VmotivosSubsanacionExpOs2
	 *
	 * @param vmotivossubsanacionexpos2 the vmotivossubsanacionexpos 2
	 */
	public void remove(VmotivosSubsanacionExpOs2 vmotivossubsanacionexpos2) {
		String query = "DELETE FROM VMOTIVOS_SUBSANACION_EXP_OS2 WHERE TEROS=? AND ANOOS=? AND NUMOS=? AND ID_TRAMITE=? AND TIPO_TRAMITE=? AND ID_TAREA=? AND TIPO_TAREA=? AND CODMOTIVO=? AND DESCRIPCION_ES=? AND DESCRIPCION_EUS=? AND DESC_OTROS_ES=? AND DESC_OTROS_EU=?";
		this.jdbcTemplate.update(query, vmotivossubsanacionexpos2.getTeros(),
				vmotivossubsanacionexpos2.getAnoos(),
				vmotivossubsanacionexpos2.getNumos(),
				vmotivossubsanacionexpos2.getIdTramite(),
				vmotivossubsanacionexpos2.getTipoTramite(),
				vmotivossubsanacionexpos2.getIdTarea(),
				vmotivossubsanacionexpos2.getTipoTarea(),
				vmotivossubsanacionexpos2.getCodmotivo(),
				vmotivossubsanacionexpos2.getDescripcionEs(),
				vmotivossubsanacionexpos2.getDescripcionEus(),
				vmotivossubsanacionexpos2.getDescOtrosEs(),
				vmotivossubsanacionexpos2.getDescOtrosEu());
	}

	/**
	 * Finds a list of rows in the VmotivosSubsanacionExpOs2 table.
	 * 
	 *  vmotivossubsanacionexpos2
	 *            VmotivosSubsanacionExpOs2
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  List<VmotivosSubsanacionExpOs2>
	 *
	 * @param vmotivossubsanacionexpos2 the vmotivossubsanacionexpos 2
	 * @param jqGridRequestDto the jq grid request dto
	 * @return the list
	 */
	@Transactional(readOnly = true)
	public List<VmotivosSubsanacionExpOs2> findAll(
			VmotivosSubsanacionExpOs2 vmotivossubsanacionexpos2,
			JQGridRequestDto jqGridRequestDto) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.TEROS TEROS,t1.ANOOS ANOOS,t1.NUMOS NUMOS,t1.ID_TRAMITE IDTRAMITE,t1.TIPO_TRAMITE TIPOTRAMITE,t1.ID_TAREA IDTAREA,t1.TIPO_TAREA TIPOTAREA,t1.CODMOTIVO CODMOTIVO,t1.DESCRIPCION_ES DESCRIPCIONES,t1.DESCRIPCION_EUS DESCRIPCIONEUS,t1.DESC_OTROS_ES DESCOTROSES,t1.DESC_OTROS_EU DESCOTROSEU ");
		query.append("FROM VMOTIVOS_SUBSANACION_EXP_OS2 t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(vmotivossubsanacionexpos2);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (jqGridRequestDto != null) {
			query = JQGridManager.getPaginationQuery(jqGridRequestDto, query);
		}

		return (List<VmotivosSubsanacionExpOs2>) this.jdbcTemplate.query(
				query.toString(), this.rwMap, params.toArray());
	}

	/**
	 * Finds rows in the VmotivosSubsanacionExpOs2 table using like.
	 * 
	 *  vmotivossubsanacionexpos2
	 *            VmotivosSubsanacionExpOs2
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  startsWith
	 *            Boolean
	 *  List<VmotivosSubsanacionExpOs2>
	 *
	 * @param vmotivossubsanacionexpos2 the vmotivossubsanacionexpos 2
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 * @return the list
	 */
	@Transactional(readOnly = true)
	public List<VmotivosSubsanacionExpOs2> findAllLike(
			VmotivosSubsanacionExpOs2 vmotivossubsanacionexpos2,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.TEROS TEROS,t1.ANOOS ANOOS,t1.NUMOS NUMOS,t1.ID_TRAMITE IDTRAMITE,t1.TIPO_TRAMITE TIPOTRAMITE,t1.ID_TAREA IDTAREA,t1.TIPO_TAREA TIPOTAREA,t1.CODMOTIVO CODMOTIVO,t1.DESCRIPCION_ES DESCRIPCIONES,t1.DESCRIPCION_EUS DESCRIPCIONEUS,t1.DESC_OTROS_ES DESCOTROSES,t1.DESC_OTROS_EU DESCOTROSEU ");
		query.append("FROM VMOTIVOS_SUBSANACION_EXP_OS2 t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(
				vmotivossubsanacionexpos2, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (jqGridRequestDto != null) {
			query = JQGridManager.getPaginationQuery(jqGridRequestDto, query);
		}

		return (List<VmotivosSubsanacionExpOs2>) this.jdbcTemplate.query(
				query.toString(), this.rwMap, params.toArray());
	}

	/*
	 * OPERACIONES RUP_TABLE
	 */

	/**
	 * Counts rows in the VmotivosSubsanacionExpOs2 table.
	 * 
	 *  vmotivossubsanacionexpos2
	 *            VmotivosSubsanacionExpOs2
	 *  Long
	 *
	 * @param vmotivossubsanacionexpos2 the vmotivossubsanacionexpos 2
	 * @return the long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(VmotivosSubsanacionExpOs2 vmotivossubsanacionexpos2) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM VMOTIVOS_SUBSANACION_EXP_OS2 t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(vmotivossubsanacionexpos2);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Counts rows in the VmotivosSubsanacionExpOs2 table using like.
	 * 
	 *  vmotivossubsanacionexpos2
	 *            VmotivosSubsanacionExpOs2
	 *  startsWith
	 *            Boolean
	 *  Long
	 *
	 * @param vmotivossubsanacionexpos2 the vmotivossubsanacionexpos 2
	 * @param startsWith the starts with
	 * @return the long
	 */
	@Transactional(readOnly = true)
	public Long findAllLikeCount(
			VmotivosSubsanacionExpOs2 vmotivossubsanacionexpos2,
			Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM VMOTIVOS_SUBSANACION_EXP_OS2 t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(
				vmotivossubsanacionexpos2, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Reorder the data list of VmotivosSubsanacionExpOs2 selected for rup_table.
	 * 
	 *  vmotivossubsanacionexpos2            VmotivosSubsanacionExpOs2
	 *  jqGridRequestDto            JQGridRequestDto
	 *  startsWith            Boolean
	 *  List<TableRowDto<VmotivosSubsanacionExpOs2>>
	 *
	 * @param vmotivossubsanacionexpos2 the vmotivossubsanacionexpos 2
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 * @return the list
	 */
	@Override
	public List<TableRowDto<VmotivosSubsanacionExpOs2>> reorderSelection(
			VmotivosSubsanacionExpOs2 vmotivossubsanacionexpos2,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		// SELECT
		StringBuilder query = new StringBuilder(
				"SELECT t1.TEROS TEROS,t1.ANOOS ANOOS,t1.NUMOS NUMOS,t1.ID_TRAMITE IDTRAMITE,t1.TIPO_TRAMITE TIPOTRAMITE,t1.ID_TAREA IDTAREA,t1.TIPO_TAREA TIPOTAREA,t1.CODMOTIVO CODMOTIVO,t1.DESCRIPCION_ES DESCRIPCIONES,t1.DESCRIPCION_EUS DESCRIPCIONEUS,t1.DESC_OTROS_ES DESCOTROSES,t1.DESC_OTROS_EU DESCOTROSEU ");
		// FROM
		query.append("FROM VMOTIVOS_SUBSANACION_EXP_OS2 t1 ");
		// FILTRADO
		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(
				vmotivossubsanacionexpos2, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		// Parámetros de filtrado
		@SuppressWarnings("unchecked")
		List<Object> filterParamList = (List<Object>) mapaWhere.get("params");

		// SQL para la reordenación
		StringBuilder sbReorderSelectionSQL = JQGridManager
				.getReorderQuery(
						query,
						jqGridRequestDto,
						VmotivosSubsanacionExpOs2.class,
						filterParamList,
						"TEROS,ANOOS,NUMOS,ID_TRAMITE,TIPO_TRAMITE,ID_TAREA,TIPO_TAREA,CODMOTIVO,DESCRIPCION_ES,DESCRIPCION_EUS,DESC_OTROS_ES,DESC_OTROS_EU");

		return this.jdbcTemplate.query(sbReorderSelectionSQL.toString(),
				new RowNumResultSetExtractor<VmotivosSubsanacionExpOs2>(
						this.rwMapPK, jqGridRequestDto), filterParamList
						.toArray());
	}

	/**
	 * Search method for rup_table.
	 * 
	 *  filterParams            VmotivosSubsanacionExpOs2
	 *  searchParams            VmotivosSubsanacionExpOs2
	 *  jqGridRequestDto            JQGridRequestDto
	 *  startsWith            Boolean
	 *  List<TableRowDto<VmotivosSubsanacionExpOs2>>
	 *
	 * @param filterParams the filter params
	 * @param searchParams the search params
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 * @return the list
	 */
	@Override
	public List<TableRowDto<VmotivosSubsanacionExpOs2>> search(
			VmotivosSubsanacionExpOs2 filterParams,
			VmotivosSubsanacionExpOs2 searchParams,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		// SELECT
		StringBuilder query = new StringBuilder(
				"SELECT t1.TEROS TEROS,t1.ANOOS ANOOS,t1.NUMOS NUMOS,t1.ID_TRAMITE IDTRAMITE,t1.TIPO_TRAMITE TIPOTRAMITE,t1.ID_TAREA IDTAREA,t1.TIPO_TAREA TIPOTAREA,t1.CODMOTIVO CODMOTIVO,t1.DESCRIPCION_ES DESCRIPCIONES,t1.DESCRIPCION_EUS DESCRIPCIONEUS,t1.DESC_OTROS_ES DESCOTROSES,t1.DESC_OTROS_EU DESCOTROSEU ");
		// FROM
		query.append("FROM VMOTIVOS_SUBSANACION_EXP_OS2 t1 ");
		// TABLAS_ALIAS
		List<String> from_alias = new ArrayList<String>();
		from_alias.add(" t1 ");

		// FILTRADO
		Map<String, ?> mapaWhereFilter = this.getWhereLikeMap(filterParams,
				startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhereFilter.get("query"));
		query.append(where);
		// Filter params
		@SuppressWarnings("unchecked")
		List<Object> filterParamList = (List<Object>) mapaWhereFilter
				.get("params");

		// BUSQUEDA
		Map<String, Object> mapaWhereSearch = this.getWhereLikeMap(
				searchParams, startsWith);
		String searchSQL = ((StringBuilder) mapaWhereSearch.get("query"))
				.toString();
		// Search params
		@SuppressWarnings("unchecked")
		List<Object> searchParamList = (List<Object>) mapaWhereSearch
				.get("params");

		// SQL
		StringBuilder sbReorderSelectionSQL = JQGridManager
				.getSearchQuery(
						query,
						jqGridRequestDto,
						VmotivosSubsanacionExpOs2.class,
						filterParamList,
						searchSQL,
						searchParamList,
						from_alias,
						"TEROS,ANOOS,NUMOS,ID_TRAMITE,TIPO_TRAMITE,ID_TAREA,TIPO_TAREA,CODMOTIVO,DESCRIPCION_ES,DESCRIPCION_EUS,DESC_OTROS_ES,DESC_OTROS_EU");

		return this.jdbcTemplate.query(sbReorderSelectionSQL.toString(),
				new RowNumResultSetExtractor<VmotivosSubsanacionExpOs2>(
						this.rwMapPK, jqGridRequestDto), filterParamList
						.toArray());
	}

	/**
	 * Remove multiple method for rup_table.
	 * 
	 *  filtervmotivossubsanacionexpos2            VmotivosSubsanacionExpOs2
	 *  jqGridRequestDto            JQGridRequestDto
	 *  startsWith            Boolean
	 *
	 * @param filtervmotivossubsanacionexpos2 the filtervmotivossubsanacionexpos 2
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 */
	@Override
	public void removeMultiple(
			VmotivosSubsanacionExpOs2 filtervmotivossubsanacionexpos2,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		// SELECT
		/** TODO: select por clave */
		StringBuilder query = new StringBuilder(
				"SELECT t1.TEROS TEROS,t1.ANOOS ANOOS,t1.NUMOS NUMOS,t1.ID_TRAMITE IDTRAMITE,t1.TIPO_TRAMITE TIPOTRAMITE,t1.ID_TAREA IDTAREA,t1.TIPO_TAREA TIPOTAREA,t1.CODMOTIVO CODMOTIVO,t1.DESCRIPCION_ES DESCRIPCIONES,t1.DESCRIPCION_EUS DESCRIPCIONEUS,t1.DESC_OTROS_ES DESCOTROSES,t1.DESC_OTROS_EU DESCOTROSEU ");
		// FROM
		query.append("FROM VMOTIVOS_SUBSANACION_EXP_OS2 t1 ");

		// WHERE
		Map<String, Object> mapaWhere = this.getWhereLikeMap(
				filtervmotivossubsanacionexpos2, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		@SuppressWarnings("unchecked")
		List<Object> params = (List<Object>) mapaWhere.get("params");

		StringBuilder sbRemoveMultipleSQL = JQGridManager
				.getRemoveMultipleQuery(
						jqGridRequestDto,
						VmotivosSubsanacionExpOs2.class,
						query,
						params,
						"TEROS,ANOOS,NUMOS,ID_TRAMITE,TIPO_TRAMITE,ID_TAREA,TIPO_TAREA,CODMOTIVO,DESCRIPCION_ES,DESCRIPCION_EUS,DESC_OTROS_ES,DESC_OTROS_EU");
		this.jdbcTemplate.update(sbRemoveMultipleSQL.toString(),
				params.toArray());
	}

	/*
	 * MÉTODOS PRIVADOS
	 */

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the VmotivosSubsanacionExpOs2 entity.
	 * 
	 *  vmotivossubsanacionexpos2            VmotivosSubsanacionExpOs2 Bean with the criteria values to
	 *            filter by.
	 *  Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 *
	 * @param vmotivossubsanacionexpos2 the vmotivossubsanacionexpos 2
	 * @return the where map
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereMap(
			VmotivosSubsanacionExpOs2 vmotivossubsanacionexpos2) {

		StringBuilder where = new StringBuilder(
				VmotivosSubsanacionExpOs2DaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (vmotivossubsanacionexpos2 != null
				&& vmotivossubsanacionexpos2.getTeros() != null) {
			where.append(" AND t1.TEROS = ?");
			params.add(vmotivossubsanacionexpos2.getTeros());
		}
		if (vmotivossubsanacionexpos2 != null
				&& vmotivossubsanacionexpos2.getAnoos() != null) {
			where.append(" AND t1.ANOOS = ?");
			params.add(vmotivossubsanacionexpos2.getAnoos());
		}
		if (vmotivossubsanacionexpos2 != null
				&& vmotivossubsanacionexpos2.getNumos() != null) {
			where.append(" AND t1.NUMOS = ?");
			params.add(vmotivossubsanacionexpos2.getNumos());
		}
		if (vmotivossubsanacionexpos2 != null
				&& vmotivossubsanacionexpos2.getIdTramite() != null) {
			where.append(" AND t1.ID_TRAMITE = ?");
			params.add(vmotivossubsanacionexpos2.getIdTramite());
		}
		if (vmotivossubsanacionexpos2 != null
				&& vmotivossubsanacionexpos2.getTipoTramite() != null) {
			where.append(" AND t1.TIPO_TRAMITE = ?");
			params.add(vmotivossubsanacionexpos2.getTipoTramite());
		}
		if (vmotivossubsanacionexpos2 != null
				&& vmotivossubsanacionexpos2.getIdTarea() != null) {
			where.append(" AND t1.ID_TAREA = ?");
			params.add(vmotivossubsanacionexpos2.getIdTarea());
		}
		if (vmotivossubsanacionexpos2 != null
				&& vmotivossubsanacionexpos2.getTipoTarea() != null) {
			where.append(" AND t1.TIPO_TAREA = ?");
			params.add(vmotivossubsanacionexpos2.getTipoTarea());
		}
		if (vmotivossubsanacionexpos2 != null
				&& vmotivossubsanacionexpos2.getCodmotivo() != null) {
			where.append(" AND t1.CODMOTIVO = ?");
			params.add(vmotivossubsanacionexpos2.getCodmotivo());
		}
		if (vmotivossubsanacionexpos2 != null
				&& vmotivossubsanacionexpos2.getDescripcionEs() != null) {
			where.append(" AND t1.DESCRIPCION_ES = ?");
			params.add(vmotivossubsanacionexpos2.getDescripcionEs());
		}
		if (vmotivossubsanacionexpos2 != null
				&& vmotivossubsanacionexpos2.getDescripcionEus() != null) {
			where.append(" AND t1.DESCRIPCION_EUS = ?");
			params.add(vmotivossubsanacionexpos2.getDescripcionEus());
		}
		if (vmotivossubsanacionexpos2 != null
				&& vmotivossubsanacionexpos2.getDescOtrosEs() != null) {
			where.append(" AND t1.DESC_OTROS_ES = ?");
			params.add(vmotivossubsanacionexpos2.getDescOtrosEs());
		}
		if (vmotivossubsanacionexpos2 != null
				&& vmotivossubsanacionexpos2.getDescOtrosEu() != null) {
			where.append(" AND t1.DESC_OTROS_EU = ?");
			params.add(vmotivossubsanacionexpos2.getDescOtrosEu());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the VmotivosSubsanacionExpOs2 entity.
	 * 
	 *  vmotivossubsanacionexpos2            VmotivosSubsanacionExpOs2 Bean with the criteria values to
	 *            filter by.
	 *  startsWith            Boolean
	 *  Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 *
	 * @param vmotivossubsanacionexpos2 the vmotivossubsanacionexpos 2
	 * @param startsWith the starts with
	 * @return the where like map
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, Object> getWhereLikeMap(
			VmotivosSubsanacionExpOs2 vmotivossubsanacionexpos2,
			Boolean startsWith) {

		StringBuilder where = new StringBuilder(
				VmotivosSubsanacionExpOs2DaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (vmotivossubsanacionexpos2 != null
				&& vmotivossubsanacionexpos2.getTeros() != null) {
			where.append(" AND UPPER(t1.TEROS) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(vmotivossubsanacionexpos2.getTeros().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ vmotivossubsanacionexpos2.getTeros().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.TEROS IS NOT NULL");
		}
		if (vmotivossubsanacionexpos2 != null
				&& vmotivossubsanacionexpos2.getAnoos() != null) {
			where.append(" AND UPPER(t1.ANOOS) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(vmotivossubsanacionexpos2.getAnoos().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ vmotivossubsanacionexpos2.getAnoos().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.ANOOS IS NOT NULL");
		}
		if (vmotivossubsanacionexpos2 != null
				&& vmotivossubsanacionexpos2.getNumos() != null) {
			where.append(" AND t1.NUMOS = ?");
			params.add(vmotivossubsanacionexpos2.getNumos());
		}
		if (vmotivossubsanacionexpos2 != null
				&& vmotivossubsanacionexpos2.getIdTramite() != null) {
			where.append(" AND t1.ID_TRAMITE = ?");
			params.add(vmotivossubsanacionexpos2.getIdTramite());
		}
		if (vmotivossubsanacionexpos2 != null
				&& vmotivossubsanacionexpos2.getTipoTramite() != null) {
			where.append(" AND t1.TIPO_TRAMITE = ?");
			params.add(vmotivossubsanacionexpos2.getTipoTramite());
		}
		if (vmotivossubsanacionexpos2 != null
				&& vmotivossubsanacionexpos2.getIdTarea() != null) {
			where.append(" AND t1.ID_TAREA = ?");
			params.add(vmotivossubsanacionexpos2.getIdTarea());
		}
		if (vmotivossubsanacionexpos2 != null
				&& vmotivossubsanacionexpos2.getTipoTarea() != null) {
			where.append(" AND t1.TIPO_TAREA = ?");
			params.add(vmotivossubsanacionexpos2.getTipoTarea());
		}
		if (vmotivossubsanacionexpos2 != null
				&& vmotivossubsanacionexpos2.getCodmotivo() != null) {
			where.append(" AND UPPER(t1.CODMOTIVO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(vmotivossubsanacionexpos2.getCodmotivo()
						.toUpperCase() + "%");
			} else {
				params.add("%"
						+ vmotivossubsanacionexpos2.getCodmotivo()
								.toUpperCase() + "%");
			}
			where.append(" AND t1.CODMOTIVO IS NOT NULL");
		}
		if (vmotivossubsanacionexpos2 != null
				&& vmotivossubsanacionexpos2.getDescripcionEs() != null) {
			where.append(" AND UPPER(t1.DESCRIPCION_ES) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(vmotivossubsanacionexpos2.getDescripcionEs()
						.toUpperCase() + "%");
			} else {
				params.add("%"
						+ vmotivossubsanacionexpos2.getDescripcionEs()
								.toUpperCase() + "%");
			}
			where.append(" AND t1.DESCRIPCION_ES IS NOT NULL");
		}
		if (vmotivossubsanacionexpos2 != null
				&& vmotivossubsanacionexpos2.getDescripcionEus() != null) {
			where.append(" AND UPPER(t1.DESCRIPCION_EUS) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(vmotivossubsanacionexpos2.getDescripcionEus()
						.toUpperCase() + "%");
			} else {
				params.add("%"
						+ vmotivossubsanacionexpos2.getDescripcionEus()
								.toUpperCase() + "%");
			}
			where.append(" AND t1.DESCRIPCION_EUS IS NOT NULL");
		}
		if (vmotivossubsanacionexpos2 != null
				&& vmotivossubsanacionexpos2.getDescOtrosEs() != null) {
			where.append(" AND UPPER(t1.DESC_OTROS_ES) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(vmotivossubsanacionexpos2.getDescOtrosEs()
						.toUpperCase() + "%");
			} else {
				params.add("%"
						+ vmotivossubsanacionexpos2.getDescOtrosEs()
								.toUpperCase() + "%");
			}
			where.append(" AND t1.DESC_OTROS_ES IS NOT NULL");
		}
		if (vmotivossubsanacionexpos2 != null
				&& vmotivossubsanacionexpos2.getDescOtrosEu() != null) {
			where.append(" AND UPPER(t1.DESC_OTROS_EU) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(vmotivossubsanacionexpos2.getDescOtrosEu()
						.toUpperCase() + "%");
			} else {
				params.add("%"
						+ vmotivossubsanacionexpos2.getDescOtrosEu()
								.toUpperCase() + "%");
			}
			where.append(" AND t1.DESC_OTROS_EU IS NOT NULL");
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;
}
